#declare r = seed(0);

#macro Rock( A, B, C )
  #local Z1 = function { pattern { granite scale 2 translate <rand(r),rand(r),rand(r)> rotate <rand(r),rand(r),rand(r)>} }
  #local Z2 = function { pattern { leopard turbulence 0.4 scale 0.20 translate <rand(r),rand(r),rand(r)> rotate <rand(r),rand(r),rand(r)> } }
  #local Z3 = function { pattern { leopard turbulence 0.3 scale 0.35 translate <rand(r),rand(r),rand(r)> rotate <rand(r),rand(r),rand(r)>} }  

  isosurface {
    function { f_sphere(x,y,z,0.8) - A*Z2(x,y,z) - B*Z3(x,y,z) -C*Z1(x,y,z) }
    contained_by { sphere { 0, 1 } }
    max_gradient 3.1
  
    scale <1, 0.5, 1>
  
    texture { 
      pigment { 
        granite
        scale 0.1
        color_map {
          [0.0 rgb 0.4]
          [0.5 rgb 0.7]
          [1.0 rgb 0.8]
          }
        }  
      #if ( Radious = 1 ) finish { ambient 0 } #end
      }
    
    //Moss on <1, 0, -1> side of tree
    texture {
      pigment {
        slope { <1.5, 0, -1>  } 
        turbulence 0.4
        scale <0.5, 2, 0.5>
        color_map {
          [0.0 rgbt <1.0, 1.0, 1.0, 1.0> ]
          [0.4 rgbt <1.0, 1.0, 1.0, 1.0> ]
          [0.65 rgbt <0.289, 0.371, 0.117, 0.0> ]
          [1.0 rgbt <0.395, 0.477, 0.207, 0.0> ]
          }
        }
      normal { bumps 1 scale 0.001 }
      #if ( Radious = 1 ) finish { ambient 0 } #end
      }
    }
#end
